% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_project.R
\name{new_project}
\alias{new_project}
\title{Create a New Framework Project}
\usage{
new_project(
  name = NULL,
  location = NULL,
  type = "project",
  browse = interactive(),
  ...
)
}
\arguments{
\item{name}{Project name. If NULL (default), prompts interactively.}

\item{location}{Directory path where project will be created. If NULL (default),
prompts interactively.}

\item{type}{Project type. One of "project" (default), "project_sensitive",
"course", or "presentation".}

\item{browse}{Whether to open the project folder after creation (default: TRUE in
interactive sessions)}

\item{...}{Additional arguments passed to `project_}
}
\value{
Invisibly returns the result from \code{project_create()} (list with success,
path, and project_id)
}
\description{
Convenience wrapper for creating Framework projects from the command line.
Uses global settings configured via \code{setup()} as defaults, prompts for
missing required values (name and location).
}
\details{
This function is designed for the streamlined workflow:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{remotes::install_github("table1/framework")
framework::setup()        # One-time global configuration
framework::new_project()  # Create projects using saved defaults
}\if{html}{\out{</div>}}

Global settings from \code{tools::R_user_dir("framework", "config")} are used for:
\itemize{
\item Author information (name, email, affiliation
\item Default packages
\item Directory structure
\item Git settings
\item AI assistant configuration
\item Quarto format preferences
}
}
\examples{
\donttest{
if (FALSE) {
# Interactive - prompts for name and location
new_project()

# With name and location specified
new_project("my-analysis", "~/projects/my-analysis")

# Create a sensitive data project
new_project("medical-study", "~/projects/medical", type = "project_sensitive")
}
}

}
\seealso{
\code{\link[=setup]{setup()}} for initial configuration, \code{\link[=project_create]{project_create()}} for full control
}
