% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequentdirections.R
\name{plot_svd}
\alias{plot_svd}
\title{Plot data using the first and second singular vector}
\usage{
plot_svd(a, label = NULL, b = a)
}
\arguments{
\item{a}{Original matrix to be sketched (n x m)}

\item{label}{Group index for each a's row. These values are used for group and color.}

\item{b}{A sketched matrix (l x m)}
}
\description{
Plot data using the first and second singular vector
}
\examples{
# Dummy data
size_col <- 50
size_row <- 10^3
x <- matrix(
  c(rnorm(size_row * size_col), rnorm(size_row * size_col, mean=1)),
  ncol = size_col, byrow = TRUE
)
x <- scale(x)
y <- rep(1:2, each=size_row)
# Show 2D plot using SVD
frequentdirections::plot_svd(x, y)
# Matrix Skethinc(l=6)
b <- frequentdirections::sketching(x, 6, 10^(-8))
# Show 2D plot using sketched matrix and show similar result with the above
# That means that 6 dim is enough to express the original data matrix (x)
frequentdirections::plot_svd(x, y, b)
}
