% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_add.R
\name{gc_add}
\alias{gc_add}
\title{Complete Gene Clusters by Adding Missing ORFs}
\usage{
gc_add(
  Data = sbgc,
  Annotation = bin_genes,
  orf_before_first = 0,
  orf_after_last = 0,
  orf_range = "All"
)
}
\arguments{
\item{Data}{A \code{data.frame} of annotated ORFs with required columns:
\itemize{
\item \code{qaccver}: ORF identifier (genome---contig_orf_position format).
\item \code{genome}, \code{contig}: Genome and contig names.
\item \code{gene}: Gene symbol (NA for hypothetical ORFs).
\item \code{orf_position}: Absolute ORF position on the contig.
\item \code{gene_cluster}: Cluster identifier.
}}

\item{Annotation}{A \code{data.frame} of full ORF annotations (e.g., from \code{\link{orf_extract}}).
Must include \code{qaccver} and \code{orf_position}.}

\item{orf_before_first}{Integer. Hypothetical ORFs to insert \strong{before} the first annotated ORF
in each cluster (bounded by contig start). Default: \code{0}.}

\item{orf_after_last}{Integer. Hypothetical ORFs to append \strong{after} the last annotated ORF
(bounded by contig end). Default: \code{0}.}

\item{orf_range}{Character. Controls ORF inclusion and annotation merging:
\itemize{
\item \code{"All"}: Include every ORF in the contig range and merge all annotations (default).
\item \code{"OnlyAnnotated"}: Keep only ORFs present in \code{Annotation} and merge their annotations.
\item \code{"IgnoreAnnotated"}: Include all ORFs but skip merging with \code{Annotation}.
}}
}
\value{
A \code{data.frame} with one row per ORF (real/hypothetical), sorted by \code{gene_cluster} and
\code{orf_position}. Added columns:
\describe{
\item{\code{GC_orf_position}}{Relative position within cluster (1-indexed).}
\item{\code{GC_present_length}}{Count of annotated ORFs in the cluster.}
\item{\code{GC_absent_length}}{Count of inserted hypothetical ORFs.}
\item{\code{GC_length}}{Total ORFs (\code{GC_present_length + GC_absent_length}).}
}
}
\description{
Expands gene cluster tables to include \strong{all ORFs} (annotated and hypothetical) within contigs,
normalizing cluster representations for downstream analysis and plotting. Ensures consistent
ORF spacing/length across clusters by inserting missing rows.
}
\details{
\itemize{
\item \strong{Hypothetical ORFs} are inserted as rows with \code{gene = NA}.
\item Output is always sorted by \code{gene_cluster} and \code{orf_position}.
\item Progress messages are printed to console with timestamps.
\item Contig bounds are respected—insertions never exceed actual ORF positions in \code{Annotation}.
}
}
