% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneSNPcustom.R
\name{geneSNPcustom}
\alias{geneSNPcustom}
\title{Identifies Candidate Genes based on identified Single Nucleotide Ploymorphisms (SNPs) from Genome Wide Association Stuides (GWAS) Analysis}
\usage{
geneSNPcustom(data_file, crop = "wheat")
}
\arguments{
\item{data_file}{The input data in .csv format. (sample_data_wheat_custom for demo purpose)}

\item{crop}{Either "wheat" or "rice". (default: wheat)}
}
\value{
A data frame containing traits, SNP, gene_id, gene_size, and gene_type.
}
\description{
Identifies Candidate Genes based on identified Single Nucleotide Ploymorphisms (SNPs) from Genome Wide Association Stuides (GWAS) Analysis
}
\examples{
load(system.file("extdata", "precomputed_sample_results_custom.rda", package = "geneNR"))
message(sample_results)
\donttest{
result <- geneSNPcustom("sample_data_wheat_custom", crop = "wheat")
}
}
