% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtfn.R
\name{rtfn}
\alias{rtfn}
\title{A generating function of triangular fuzzy number via uniform distribution}
\usage{
rtfn(n, a, b)
}
\arguments{
\item{n}{total number of random triangular fuzzy number}

\item{a}{the left point of triangular fuzzy number}

\item{b}{the right point of triangular fuzzy number}
}
\value{
A data frame with two variables, that is, x and mf
}
\description{
A generating function of triangular fuzzy number via uniform distribution based on Souliotis et al. (2022). See detail in references.
}
\examples{
df <- rtfn(500,1,5)
head(df)
plot(df) # or plot(df,type='h')
}
\references{
Souliotis, G., Alanazi, Y., & Papadopoulos, B. (2022). Construction of fuzzy numbers via cumulative distribution function. Mathematics, 10(18), 3350. https://doi.org/10.3390/math10183350
}
