% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_population_grid.R
\name{get_population_grid}
\alias{get_population_grid}
\title{Get Finnish Population grid in two different resolutions for years 2010-2022
Thin wrapper around Finnish population grid data provided by
\href{https://stat.fi/org/avoindata/paikkatietoaineistot/vaestoruutuaineisto_1km_en.html}{Statistics Finland}.}
\usage{
get_population_grid(year = 2022, resolution = 5)
}
\arguments{
\item{year}{A numeric for year of the population grid. Years available 2005 and 2010-2022.}

\item{resolution}{1 (1km x 1km) or 5 (5km x 5km)}
}
\value{
sf object
}
\description{
Get Finnish Population grid in two different resolutions for years 2010-2022
Thin wrapper around Finnish population grid data provided by
\href{https://stat.fi/org/avoindata/paikkatietoaineistot/vaestoruutuaineisto_1km_en.html}{Statistics Finland}.
}
\details{
More information about the dataset from \href{https://www.paikkatietohakemisto.fi/geonetwork/srv/eng/catalog.search#/metadata/a901d40a-8a6b-4678-814c-79d2e2ab130c}{Paikkatietohakemisto}
}
\examples{
 \dontrun{
 f <- get_population_grid(year=2017)
 plot(f)
 }

}
\author{
Markus Kainu \href{mailto:markus.kainu@kela.fi}{markus.kainu@kela.fi}, Joona Lehtomäki \href{mailto:joona.lehtomaki@iki.fi}{joona.lehtomaki@iki.fi}
}
