\name{geosptdb-package}
\alias{geosptdb-package}
\alias{geosptdb}
\docType{package}
\title{Spatio-Temporal Radial Basis Functions with Distance-Based Methods (Optimization, Prediction and Cross Validation)}
\description{
Spatio-temporal: Inverse Distance Weighting (IDW) and radial basis functions; optimization, prediction, summary statistics
from leave-one-out cross-validation, adjusting distance-based linear regression model and generation
of the principal coordinates of a new individual from Gower's distance.
}
\details{
\tabular{ll}{
Package: \tab geosptdb\cr
Type: \tab Package\cr
Version: \tab 1.0-2\cr
Date: \tab 2025-06-21\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab yes\cr
}
}
\author{
Carlos Melo <cmelo@udistrital.edu.co>, Oscar Melo <oomelom@unal.edu.co>,  Sandra Melo <semelom@unal.edu.co>

Maintainer: Carlos Melo <cmelo@udistrital.edu.co>
}
\references{
Cuadras CM, Arenas C, Fortiana J (1996). \emph{Some computational aspects of a distance-based model
	for prediction}. Communications in Statistics B - Simulation and Computation 25, 593-609.

Cuadras, CM. and Arenas, C. (1990).\emph{A distance-based regression model for prediction with mixed data}.
Communications in Statistics A - Theory and Methods 19, 2261-2279

Gower, J. C. (1971). \emph{A general coefficient of similarity and some of its properties}. Biometrics 27:857-871.

Hengl, T. (2009). \emph{A Practical Guide to Geostatistical Mapping}, 2nd edn, University of Amsterdam, Amsterdam.

Hengl, T., Heuvelink Gerard, B. M., Percec Tadic, M. & Pebesma, E. J. (2012).
\emph{Spatio-temporal prediction of daily temperatures using time-series of
MODIS LST images}, Theoretical and Applied Climatology 107, 1-2, 265-277.

Johnston, K., Ver, J., Krivoruchko, K., Lucas, N. 2001. \emph{Using ArcGIS Geostatistical Analysis}. ESRI.

Melo, C. E. (2012). \emph{Analisis geoestadistico espacio tiempo basado en distancias y splines con aplicaciones}. PhD. Thesis. Universitat de Barcelona. 276 p. \href{http://www.tdx.cat/bitstream/handle/10803/101202/CEMM_TESIS.pdf}{[link]}
}
\keyword{ package }
\keyword{ spatio-temporal }
\seealso{
\code{\link{rbfST}}, \code{\link{graph.rbfST}}, \code{\link{cp.xnews}}, \code{\link{croatiadb}}
}
