% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_plot.R
\name{build_plot}
\alias{build_plot}
\title{Incrementally build and save layers of a ggplot object into numbered files}
\usage{
build_plot(plot, filepath = NULL, build_order, subdir = "builds",
  ext = tools::file_ext(filepath), build_ext = ext, save_full = TRUE,
  save_rds = FALSE, preserve_order = TRUE, ...)
}
\arguments{
\item{plot}{ggplot object. The final plot to build towards.}

\item{filepath}{character string specifying where to save the plot, with or
without extensions. If the filepath is given without extension, the
\code{ext} and/or \code{build_ext} arguments must be specified.
Non-existing paths are created automatically.
If not specified (or set to NULL), plots are \code{print}ed.}

\item{build_order}{list of numerical vectors. The order in which to build
each layer of the plot, where the first (lowest) layer is 1. Multiple
layers can be built at a single increment by specifying the list element as
a vector of two or more values.}

\item{subdir}{character string. Specifies where to save the incremental
builds, as opposed to the final, full plot. (default: "builds")}

\item{ext}{character string. Extension for the full plot. Also used as
extension for builds if \code{build_ext} is not specified}

\item{build_ext}{(Optional) character string. If specified, the incremental
builds will be saved in this format (e.g., one could save the final plot as
a pdf, but save the incremental builds as a png which might be easier to
add to slides.)}

\item{save_full}{logical. Whether or not to save the full plot (default:
TRUE)}

\item{save_rds}{logical. Whether or not to save the full ggplot object as an
rds file with the same filepath. (default: FALSE)}

\item{preserve_order}{logical. Whether or not to keep the original order of
the layers. Only relevant if the specified \code{build_order} is not
monotonically increasing.}

\item{...}{other arguments, passed to \code{\link[ggplot2]{ggsave}} (e.g.
width/height)}
}
\value{
Saves plots to specified path.
}
\description{
\code{build_plot} save a ggplot object incrementally, adding geom layers in
the order specified with a list in the \code{build_order} argument.
}
\details{
The graphic device is either automatically detected from the \code{filepath},
or can be set explicitly with \code{ext}. By default, the final, complete
plot is saved in \code{filepath}, and the incremental builds are saved in a
subdirectory specified with \code{subdir}, "builds" by default. Sometimes,
it's useful to also keep the full ggplot object as an rds file for future
edits, which can be done by setting the \code{save_rds} argument to TRUE.
}
\examples{
X <- rnorm(20)
Y <- X + rnorm(20)

set.seed(1)
pd <- data.frame(X, Y)
p <- ggplot(pd, aes(X, Y)) +
  geom_smooth() +
  geom_point()

# Plot smooth, and then point
build_plot(p, build_order = list(1, 2))

# Plot point, and then smooth, but preserve order (i.e, keep points on top)
build_plot(p, build_order = list(2, 1))

# Plot point, and then smooth, and draw smooth layer on top of point
build_plot(p, build_order = list(2, 1), preserve_order = FALSE)

}
