% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{fd_unique}
\alias{fd_unique}
\title{Keep figure name unique by removing older figures with the same name}
\usage{
fd_unique(fdObj = fd_get_db(), by = "updated_date")
}
\arguments{
\item{fdObj}{An object of class \code{fdObj}.}

\item{by}{A character string specifying the method to keep the figure with the unique name. It can be either "updated_date" or "created_date".}
}
\value{
An object of class \code{fdObj}.
}
\description{
This function keeps the figure name unique by removing the older figures with the same name.
Users can specify whether to keep the figure with the latest updated date or the latest created date.
If a figure is created without changing, the created date and updated date are the same.
}
\examples{
library(ggplot2)
## create ggfigdone database in a temporary directory
db_dir = file.path(tempdir(), "fd_unique")
fo = fd_init(db_dir, rm_exist = TRUE)

## Draw a ggplot figure
g = ggplot(mtcars, aes(x=wt, y=mpg)) + geom_point()

## Add the figure to the database
fd_add(g = g, name  = "fig1", fdObj = fo)

## Add the another figure with the same name
fd_add(g = g + theme_classic(), name  = "fig1", fdObj = fo)

## Keep the figure with the latest created date
fd_unique(fdObj = fo, by = "created_date")

## Show the updated ggfigdone database
print(fo)

}
