% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spatial-rect.R
\docType{data}
\name{geom_spatial_rect}
\alias{geom_spatial_rect}
\alias{geom_spatial_tile}
\alias{StatSpatialRect}
\alias{StatSpatialTile}
\title{Projected rectangular regions}
\format{
An object of class \code{StatSpatialRect} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 4.

An object of class \code{StatSpatialTile} (inherits from \code{StatSpatialRect}, \code{Stat}, \code{ggproto}, \code{gg}) of length 4.
}
\usage{
geom_spatial_rect(
  mapping = NULL,
  data = NULL,
  ...,
  crs = NULL,
  detail = 30,
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_spatial_tile(
  mapping = NULL,
  data = NULL,
  ...,
  crs = NULL,
  detail = 30,
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

StatSpatialRect

StatSpatialTile
}
\arguments{
\item{mapping}{An aesthetic mapping created with \code{\link[ggplot2:aes]{ggplot2::aes()}}.}

\item{data}{A data frame or other object, coerced to a data.frame by \code{\link[ggplot2:fortify]{ggplot2::fortify()}}.}

\item{...}{Passed to the combined stat/geom as parameters or fixed aesthetics.}

\item{crs}{The crs of the x and y aesthetics, or NULL to use default lon/lat
crs (with a message).}

\item{detail}{Passed to \code{\link[sf:geos_unary]{sf::st_segmentize()}}: the number of line segments
per quadrant of the bounding box. Increase this number for a smoother
projected bounding box.}

\item{linejoin}{How corners should be joined}

\item{na.rm}{Should missing aesthetic values be removed?}

\item{show.legend, inherit.aes}{See \code{\link[ggplot2:layer]{ggplot2::layer()}}.}
}
\description{
If you need to plot a \code{\link[sf:st_bbox]{sf::st_bbox()}}, use \code{\link[=layer_spatial]{layer_spatial()}} instead.
While the implementation is slightly differrent, these functions are
intended to behave identically to \code{\link[ggplot2:geom_tile]{ggplot2::geom_rect()}} and
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile()}}.
}
\examples{
library(ggplot2)
tile_df <- expand.grid(
  x = seq(-140, -52, by = 20),
  y = seq(40, 70, by = 10)
)

ggplot(tile_df, aes(x, y)) +
  geom_spatial_tile(crs = 4326) +
  coord_sf(crs = 3979)

# the same plot using geom_spatial_rect()
ggplot(
  tile_df,
  aes(xmin = x - 10, xmax = x + 10, ymin = y - 5, ymax = y + 5)
) +
  geom_spatial_rect(crs = 4326) +
  coord_sf(crs = 3979)

}
\keyword{datasets}
