% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSexp2P.R
\name{SSexp2P}
\alias{SSexp2P}
\title{Self-Starting Nls 'exp2P' Regression Model}
\usage{
SSexp2P(predictor, a, b)
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model.}

\item{a, b}{The numeric parameters responding to the exp2P model.}
}
\value{
No return value (called for side effects).
}
\description{
This selfStart model evaluates the power regression function (formula as: y=a*exp(b*x)). It has an initial attribute that will evaluate initial estimates of the parameters 'a' and 'b' for a given set of data.
}
\examples{
library(ggtrendline)
x<-1:5
y<-c(2,4,8,20,25)
xy<-data.frame(x,y)
getInitial(y ~ SSexp2P(x,a,b), data = xy)
## Initial values are in fact the converged values

fitexp2P <- nls(y~SSexp2P(x,a,b), data=xy)
summary(fitexp2P)

prediction <- predFit(fitexp2P , data.frame(x=x), se.fit = TRUE,
                          level = 0.95, interval = "confidence")
yfitexp2P <- prediction$fit
yfitexp2P  # output a matrix of predictions and bounds with column names fit, lwr, and upr.

}
\seealso{
\code{\link{ggtrendline}}, \code{\link{SSexp3P}}, \code{\link{SSpower3P}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}
}
