% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pages.R
\name{pages}
\alias{pages}
\alias{pages_enabled}
\alias{pages_status}
\alias{pages_create}
\alias{pages_delete}
\title{Retrieve information about GitHub Pages sites and builds.}
\usage{
pages_enabled(repo)

pages_status(repo)

pages_create(
  repo,
  build_type = c("legacy", "workflow"),
  branch = "main",
  path = "/docs"
)

pages_delete(repo)
}
\arguments{
\item{repo}{Character. Address of repositories in \code{owner/name} format.}

\item{build_type}{Character. Either \code{"workflow"} or \code{"legacy"} - the former uses GitHub actions to
build and publish the site (requires a workflow file to achieve this).}

\item{branch}{Character. Repository branch to publish.}

\item{path}{Character. Repository path to publish.}
}
\value{
\code{pages_enabled()} returns a named logical vector - \code{TRUE} if a Pages site exists, \code{FALSE} otherwise.

\code{pages_status()} returns a tibble containing details on Pages sites.

\code{pages_create()} & \code{pages_delete()} return an invisible list containing the API responses.
}
\description{
\itemize{
\item \code{pages_enabled()} - returns \code{TRUE} if a Pages site exists for the repo.
\item \code{pages_status()} - returns more detailed information about a repo's Pages site.
\item \code{pages_create()} - creates a Pages site for the provided repos.
\item \code{pages_delete()} - deletes the Pages site for the provided repos.
}
}
\examples{
\dontrun{
pages_enabled("rundel/ghclass")

pages_status("rundel/ghclass")
}

}
