% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_control.r
\name{download_control}
\alias{download_control}
\alias{download_control.numeric}
\alias{download_control.list}
\alias{download_control_global}
\title{Download data for control keywords}
\usage{
download_control(control, locations = gt.env$countries, ...)

\method{download_control}{numeric}(control, locations = gt.env$countries, ...)

\method{download_control}{list}(control, locations = gt.env$countries, ...)

download_control_global(control, ...)
}
\arguments{
\item{control}{Control batch for which the data is downloaded. Object
of type \code{numeric} or object of type \code{list} containing single
objects of type \code{numeric}.}

\item{locations}{List of countries or regions for which the data is
downloaded. Refers to lists generated in \code{start_db}. Defaults to
\code{gt.env$countries}.}

\item{...}{Arguments that are passed on to the \code{gtrendsR::gtrends} function.}
}
\value{
Message that data has been downloaded successfully. Data is written
to table \emph{data_control}.
}
\description{
The function downloads search volumes from Google Trends for a \emph{control}
batch in a set of \emph{locations}. Data is automatically written to table
\emph{data_control}. For \code{download_control_global} the input
\emph{location} is automatically set to \emph{world}.
}
\details{
Downloads through the Google Trends API are made through
\code{gtrendsR::gtrends}. Each control batch can consist of up to five
keywords and is predefined in tables \emph{batch_keywords} and
\emph{batch_time} through \code{add_keywords}. The download for a single
keyword batch for a single location takes about 30 seconds. This includes a
randomized waiting period of 5-10 seconds between downloads. Depending on
the frequency of downloads, Google Trends might block users for some time. In
this case, \code{download_control} waits 60 minutes before it retries the
download.
}
\section{Warning}{

We advise against the usage of \emph{category codes} in
downloads. If you use \emph{categories} to narrow the context of keyword usage,
these categories are applied to \strong{ALL} keywords in the batch. This applies
to \emph{control} keywords as well as \emph{object} keywords and can result in
unintended behavior.
}

\examples{
\dontrun{
download_control(
  control = 1,
  locations = countries
)
download_control(
  control = as.list(1:5),
  locations = countries
)
}

}
\seealso{
\itemize{
\item \code{\link[=example_control]{example_control()}}
\item \code{\link[gtrendsR:gtrends]{gtrendsR::gtrends()}}
}
}
