% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_conditional.R
\name{alpha.cond}
\alias{alpha.cond}
\title{Conditional analysis for genetic variance effects}
\usage{
alpha.cond(qt, g, g_covar, iter_num = 50)
}
\arguments{
\item{qt}{A numeric vector.}

\item{g}{An integer vector.}

\item{g_covar}{An integer matrix where each column corresponds to a genetic covariate}

\item{iter_num}{An integer. Represents the number of iterations performed in the Gauss-Newton algorithm}
}
\value{
A list with the values:
* alpha, the estimated variance effect, conditioned on the covariates
* pval, the p-value corresponding to alpha
}
\description{
We estimate the variance effect of a primary variant conditioned on one or more secondary variants.
We apply a likelyhood ratio test with one degree of freedom

H0: All secondary variants have a variance effect, but not the primary one.
H1: All variants have a variance effect, including the primary one

Under both models we assume a full mean effect model. That is, the number of mean-value parameters is 3^(n+1), where n is the number of covariates
Thus the null model has 3^(n+1)+n degrees of freedom whereas the alternative model has 3^(n+1)+n+1
Due to the exponential growth of free parameters, the test might have low statistical power if many covariates are used

IMPORTANT NOTE: We use the Gauss-Newton algorithm to estimate many parameters.
We do not check if the algorithm converges to the true minimum values, or if it converges at all.
Thus, we advise against blindly believing all results
}
\examples{
n <- 10000
qt <- rnorm(n)
g <- rbinom(n, 2, 0.3)
qt <- qt * 1.2^g
g_covar <- as.data.frame(matrix(0, nrow = n, ncol = 3))
for(i in 1:ncol(g_covar)){
  freq <- runif(1, min = 0, max = 1)
  g_covar[, i] <- rbinom(n, 2, freq)
}
res <- alpha.cond(qt, g, g_covar)
}
