% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grPipe.node.R
\name{grPipe.node}
\alias{grPipe.node}
\title{Add or Update grPipe Nodes}
\usage{
grPipe.node(nodes, id, id_next, text)
}
\arguments{
\item{nodes}{data.frame}

\item{id}{character}

\item{id_next}{character}

\item{text}{character}
}
\value{
Returns a data.frame with 3 columns (id, id_next and text) where:
\itemize{
    \item If \strong{id} and \strong{id_next} already exist in the data.frame \strong{nodes}, then return the data.frame \strong{nodes} with the value \strong{text} updated;
    \item Otherwise, add a row in the data.frame \strong{nodes} with the values passed (\strong{id}, \strong{id_next} and \strong{text}) and then return the data.frame \strong{nodes}.
}
}
\description{
add a new node if it doesn't exist or update an existing one.
}
\examples{
nodes = grPipe.create(2,5)
nodes = grPipe.node(nodes, "A1",  "A2",  "input")
nodes = grPipe.node(nodes, "A2",  "B2",  "step 1")
nodes = grPipe.node(nodes, "B2",  "B3",  "step 2")
nodes = grPipe.node(nodes, "B3",  "B4",  "step 3")
nodes = grPipe.node(nodes, "B4",  "A4",  "step 4")
nodes = grPipe.node(nodes, "A4",  "A5",  "step 5")
nodes = grPipe.node(nodes, "A5",  NA,  "output")

}
\author{
Daniel Gaspar Gonçalves
}
