% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridstackeR.R
\name{grid_stack}
\alias{grid_stack}
\title{Grid Stack Container}
\usage{
grid_stack(
  ...,
  id = "gridstackeR-grid",
  opts = "{cellHeight: 70}",
  ncols = 12,
  nrows = 12,
  dynamic_full_window_height = FALSE,
  height_offset = 0
)
}
\arguments{
\item{...}{content to include in the container}

\item{id}{the id of the grid_stack container}

\item{opts}{grid options: check
\href{https://github.com/gridstack/gridstack.js/tree/master/doc#grid-options}{ gridstack documentation}
for more details}

\item{ncols}{number of columns for the grid (If you need > 12 columns you need to generate the CSS manually)}

\item{nrows}{number of rows for the grid}

\item{dynamic_full_window_height}{if TRUE, the grid will change dynamically to fit the window size minus the \code{height_offset}}

\item{height_offset}{margin for the grid height, see \code{dynamic_full_window_height}}
}
\value{
a grid_stack that can contain resizable and draggable \code{grid_stack_item}s
}
\description{
This acts as a container for the \link{grid_stack_item}'s.
}
\examples{
\dontrun{
library(gridstackeR)
library(shiny)
library(shinydashboard)
library(shinyjs)


ui <- dashboardPage(
  title = "gridstackeR Demo",
  dashboardHeader(),
  dashboardSidebar(disable = TRUE),
  dashboardBody(
    useShinyjs(),
    # make sure the content fills the given height
    tags$style(".grid-stack-item-content {height:100\%;}"),
    grid_stack(
      dynamic_full_window_height = TRUE,
      grid_stack_item(
        h = 2, w = 2, style = "overflow:hidden",
        box(
          title = "gridstackeR", status = "success", solidHeader = TRUE,
          width = 12, height = "100\%",
          div("Drag and scale the Boxes as desired")
        )
      ),
      grid_stack_item(
        h = 4, w = 4, id = "plot_container", style = "overflow:hidden",
        box(
          title = "Histogram", status = "primary", solidHeader = TRUE,
          width = 12, height = "100\%",
          plotOutput("plot", height = "auto")
        )
      ),
      grid_stack_item(
        h = 3, w = 4, minH = 3, maxH = 3, id = "slider", style = "overflow:hidden",
        box(
          title = "Inputs", status = "warning", solidHeader = TRUE,
          width = 12, height = "100\%",
          sliderInput("slider", "Slider input:", 1, 100, 50)
        )
      ),
      grid_stack_item(
        w = 4, h = 10, x = 0, y = 0, id = "c_table",
        DT::dataTableOutput("mytable")
      )
    )
  )
)

server <- function(input, output, session) {

  output$plot <- renderPlot({
    x    <- faithful$waiting
    bins <- seq(min(x), max(x), length.out = input$slider + 1)

    hist(x, breaks = bins, col = "#75AADB", border = "white",
         xlab = "Waiting time to next eruption (in mins)",
         main = "Histogram of waiting times")

  },
  # set the height according to the container height (minus the margins)
  height = function() {max(input$plot_container_height - 80, 150)}
  )

  output$mytable <- DT::renderDataTable({
    DT::datatable(mtcars, options = list(
      # set the height according to the container height (minus the margins)
      scrollY = max(input$c_table_height, 200) - 110, paging = FALSE
    )
    )
  })
}

shinyApp(ui, server)

}

}
