% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{euclidean}
\alias{euclidean}
\title{Euclidean Distance Function Factory}
\usage{
euclidean(dist = 1)
}
\arguments{
\item{dist}{threshold above which the function will return \code{FALSE}}
}
\value{
function that checks if Euclidean distance between two vectors
exceeds \code{dist}
}
\description{
Returns a function that checks whether the Euclidean distance between two
numeric vectors is less than or equal to a given threshold.
}
\examples{
# test data: Euclidean distance equals sqrt(2) ~ 1.414
x <- rep(0, 5)
y <- c(0, 1, 0, 0, 1)

# should return TRUE when checking Manhattan distance <= 2
dist_2 <- euclidean(2)
dist_2(x, y)

# should return FALSE when checking Manhattan distance <= 1
dist_1 <- euclidean(1)
dist_1(x, y)

}
