% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_cubes.R
\name{fd_cubes}
\alias{fd_cubes}
\title{Calculate fractal dimension using the cube counting method}
\usage{
fd_cubes(data, lvec = NULL, plot = FALSE, keep_data = FALSE, scale = FALSE)
}
\arguments{
\item{data}{An object of class RasterLayer or mesh3d.}

\item{lvec}{Vector of scales to use for calculation (i.e. cube sizes).}

\item{plot}{Planar representation of cubes superimposed on 3D mesh or DEM for visualizing \code{lvec}. Default = FALSE.}

\item{keep_data}{Logical. Keep calculation data? Default = FALSE.}

\item{scale}{Logical. Rescale height values to the extent? Only relevant for RasterLayer objects. (Defaults to FALSE).}
}
\value{
A value for fractal dimension, typically between 2 and 3 or a list if keep_data = TRUE.
}
\description{
Calculate fractal dimension using the cube counting method
}
\details{
This function calculates fractal dimension using the cube counting method.
If \code{lvec} is not specified, a default based on resolution and extent will be used.
Based on lvec, cubes of different sizes are defined and the function counts mesh points that fall within each cube.
It is recommended to specify the maximum value of \code{lvec} so that the largest box encapsulates the entire object.
The smallest scale included in \code{lvec} should not be smaller than the resolution of your object.
}
\examples{
fd_cubes(mcap, keep_data = TRUE, plot = TRUE)
fd_cubes(mcap, lvec = c(0.05, 0.1, 0.25, 0.5), plot = TRUE)

dem <- dem_crop(horseshoe, x0 = -469, y0 = 1267, L = 2, plot = TRUE)
fd_cubes(dem, plot = TRUE, keep_data = TRUE)
fd_cubes(dem, plot = TRUE, keep_data = TRUE, scale = TRUE)

}
\seealso{
\code{\link[=fd]{fd()}}
}
