% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sEM.R
\name{sEM}
\alias{sEM}
\title{sparse expectation-maximization algorithm for high-dimensional vector autoregression with measurement error}
\usage{
sEM(
  Y,
  A_init,
  sig2_eta_init,
  sig2_epsilon_init,
  Ti_train = NULL,
  Ti_gap = NULL,
  tol_seq = NULL,
  ht_seq = 0,
  is_cv = TRUE,
  thres = 0.001,
  count_vanish = 1,
  n_em = NULL,
  is_echo = FALSE,
  is_sparse = TRUE
)
}
\arguments{
\item{Y}{observations of time series, a p by T matrix.}

\item{A_init}{a p by p matrix as initial value of transition matrix \eqn{A} estimate.}

\item{sig2_eta_init}{scalar; initial value of propagation error variance \eqn{\sigma_\eta^2} estimate in latent signal process.}

\item{sig2_epsilon_init}{scalar; initial value of measurement error variance \eqn{\sigma_\epsilon^2} estimate in observation process.}

\item{Ti_train}{scalar; the number of time points in training data in cross-validation.}

\item{Ti_gap}{scalar; the number of time points between test data and train data in cross-validation.}

\item{tol_seq}{vector; grid of tolerance parameter in Dantzig selector for cross-validation. If \code{is_cv=FALSE}, use the first element.}

\item{ht_seq}{vector; grid of hard-thresholding levels for transition matrix estimate. If \code{is_cv=FALSE}, use the first element.
To avoid hard thresholding, set \code{ht_seq=0}.}

\item{is_cv}{logical; if true, run cross-validation to tune Dantzig selector tolerance parameter each sparse EM iteration.}

\item{thres}{scalar; if the difference between updates of two consecutive iterations is less that \code{thres}, record one hit.
The algorithm is terminated due to vanishing updates if hit times accumulate up to \code{count_vanish}. If \code{thres=NULL}, the algorithm will not be terminated
due to vanishing updates, but too many iterations instead.}

\item{count_vanish}{scalar; if the difference between updates of two consecutive
iterations is less that \code{thres} up to \code{count_vanish} times, the algorithm is terminated due to vanishing updates.}

\item{n_em}{scalar; the maximal allowed number of EM iterations, otherwise the algorithm is terminated due to too many iterations.
If \code{n_em=NULL}, the algorithm will not be terminated due to too many iterations, but vanishing updates instead.}

\item{is_echo}{logical; if true, display the information of CV-optimal (tol, ht) each iteration, and of algorithm termination.}

\item{is_sparse}{logical; if false, use standard EM algorithm, and arguments for cross-validation are not needed.}
}
\value{
a list of parameter estimates.
\tabular{ll}{
\code{A_est}  \tab  estimate of transition matrix \eqn{A}. \cr
\code{sig2_eta_hat}  \tab  estimate of propagation error variance \eqn{\sigma_\eta^2}. \cr
\code{sig2_epsilon_hat}  \tab   estimate of measurement error variance \eqn{\sigma_\epsilon^2}. \cr
\code{iter_err} \tab   the difference between updates of two consecutive iterations. \cr
\code{iter_err_ratio} \tab  the difference ratio (over the previous estimate) between updates of two consecutive iterations. \cr
}
}
\description{
Alteranting between expectation step (by kalman filter and smoothing) and maximization step (by generalized Dantzig selector for transiton matrix)
to estimate transtion matrix and error variances.
}
\examples{
p= 3; Ti=20  # dimension and time
A=diag(1,p) # transition matrix
sig_eta=sig_epsilon=0.2 # error std
Y=array(0,dim=c(p,Ti)) #observation t=1, ...., Ti
X=array(0,dim=c(p,Ti)) #latent t=1, ...., T
Ti_burnin=30 # time for burn-in to stationarity
for (t in 1:(Ti+Ti_burnin)) {
  if (t==1){
    x1=rnorm(p)
  } else if (t<=Ti_burnin) { # burn in
    x1=A\%*\%x1+rnorm(p,mean=0,sd=sig_eta)
  } else if (t==(Ti_burnin+1)){ # time series used for learning
    X[,t-Ti_burnin]=x1
    Y[,t-Ti_burnin]=X[,t-Ti_burnin]+rnorm(p,mean=0,sd=sig_epsilon)
  } else {
    X[,t- Ti_burnin]=A\%*\%X[,t-1- Ti_burnin]+rnorm(p,mean=0,sd=sig_eta)
    Y[,t- Ti_burnin]=X[,t- Ti_burnin]+rnorm(p,mean=0,sd=sig_epsilon)
  }
}

sEM_fit=sEM(Y,diag(0.5,p),0.1,0.1,Ti*0.5,Ti*0.2,c(0.01,0.1))


}
\author{
Xiang Lyu, Jian Kang, Lexin Li
}
