% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_draft.R
\name{extract_draft}
\alias{extract_draft}
\title{Extract multiple patterns into a single draft object}
\usage{
extract_draft(filepath, ...)
}
\arguments{
\item{filepath}{A valid character string to the plaintext file containing
the pattern.}

\item{...}{Keywords to be used by \code{\link[heddlr]{extract_pattern}} to
extract each pattern. If arguments to ... are named, the returned draft
will have the same names.}
}
\value{
Returns a list (the same length as ...) containing the extracted
patterns.
}
\description{
When working with multiple patterns that will be woven into a template,
it makes sense to have all patterns stored in a central object. This
function creates that object from a named vector of filenames to be used
in further generation, importing the files via
\code{\link[heddlr]{extract_pattern}}.
}
\examples{
pattern_file <- tempfile("out", tempdir(), ".Rmd")
export_template("EXTRACT my sample pattern EXTRACT", pattern_file)
extract_draft(pattern_file, "one" = "EXTRACT")
}
\seealso{
Other import functions: 
\code{\link{extract_pattern}()},
\code{\link{import_draft}()},
\code{\link{import_pattern}()}
}
\concept{import functions}
