% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{search_subsidies}
\alias{search_subsidies}
\title{Search subsidies}
\usage{
search_subsidies(
  query,
  page = 1,
  sort = NULL,
  token = Sys.getenv("HLIDAC_TOKEN")
)
}
\arguments{
\item{query}{Search query}

\item{page}{Page number (Please note that if the page parameter exceeds 200, the function returns error)}

\item{sort}{Sorting of results, the available options are the following:
- 0: order by relevance
- 1: order by the date of signature, the most recent first
- 2: order by the date of signature, the most recent last
- 3: order by the size of the subsidy, the largest first
- 4: order by the size of the subsidy, the largest last
- 5: order by ICO in a descending order
- 6: order by ICO in an ascending order}

\item{token}{Authorization token}
}
\value{
list containing 3 elements:
- total: Total number of datasets available (integer)
- page: Page of the result (integer), equal to the `page` argument of the function
- results: Data.frame with data, columns vary depending on the dataset
}
\description{
Search subsidies
}
\examples{
\dontrun{
search_subsidies("golf")
}
}
\seealso{
\url{https://www.hlidacstatu.cz/swagger/index.html}

\url{https://www.hlidacstatu.cz/api/v1/doc}

Other Subsidies: 
\code{\link{get_subsidy}()}
}
\concept{Subsidies}
