% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_roster.R
\name{nba_commonallplayers}
\alias{nba_commonallplayers}
\title{\strong{Get NBA Stats API All Players}}
\usage{
nba_commonallplayers(
  is_only_current_season = 0,
  league_id = "00",
  season = year_to_season(most_recent_nba_season() - 1),
  ...
)
}
\arguments{
\item{is_only_current_season}{is_only_current_season}

\item{league_id}{league_id}

\item{season}{season}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: CommonAllPlayers

\strong{CommonAllPlayers}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   DISPLAY_LAST_COMMA_FIRST \tab character \cr
   DISPLAY_FIRST_LAST \tab character \cr
   ROSTERSTATUS \tab character \cr
   FROM_YEAR \tab character \cr
   TO_YEAR \tab character \cr
   PLAYERCODE \tab character \cr
   PLAYER_SLUG \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_CITY \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CODE \tab character \cr
   TEAM_SLUG \tab character \cr
   GAMES_PLAYED_FLAG \tab character \cr
   OTHERLEAGUE_EXPERIENCE_CH \tab character \cr
}
}
\description{
\strong{Get NBA Stats API All Players}

\strong{Get NBA Stats API All Players}
}
\details{
\href{https://www.nba.com/players}{All Players}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  nba_commonallplayers(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Roster Functions: 
\code{\link{nba_commonplayerinfo}()},
\code{\link{nba_commonteamroster}()}
}
\author{
Saiem Gilani
}
\concept{NBA Roster Functions}
