% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_draft.R
\name{nba_draftcombinespotshooting}
\alias{nba_draftcombinespotshooting}
\title{\strong{Get NBA Stats API Draft Combine - Spot Shooting}}
\usage{
nba_draftcombinespotshooting(
  league_id = "00",
  season_year = most_recent_nba_season() - 1,
  ...
)
}
\arguments{
\item{league_id}{league_id}

\item{season_year}{season_year}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: Results

\strong{Results}\tabular{ll}{
   col_name \tab types \cr
   TEMP_PLAYER_ID \tab character \cr
   PLAYER_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   PLAYER_NAME \tab character \cr
   POSITION \tab character \cr
   FIFTEEN_CORNER_LEFT_MADE \tab character \cr
   FIFTEEN_CORNER_LEFT_ATTEMPT \tab character \cr
   FIFTEEN_CORNER_LEFT_PCT \tab character \cr
   FIFTEEN_BREAK_LEFT_MADE \tab character \cr
   FIFTEEN_BREAK_LEFT_ATTEMPT \tab character \cr
   FIFTEEN_BREAK_LEFT_PCT \tab character \cr
   FIFTEEN_TOP_KEY_MADE \tab character \cr
   FIFTEEN_TOP_KEY_ATTEMPT \tab character \cr
   FIFTEEN_TOP_KEY_PCT \tab character \cr
   FIFTEEN_BREAK_RIGHT_MADE \tab character \cr
   FIFTEEN_BREAK_RIGHT_ATTEMPT \tab character \cr
   FIFTEEN_BREAK_RIGHT_PCT \tab character \cr
   FIFTEEN_CORNER_RIGHT_MADE \tab character \cr
   FIFTEEN_CORNER_RIGHT_ATTEMPT \tab character \cr
   FIFTEEN_CORNER_RIGHT_PCT \tab character \cr
   COLLEGE_CORNER_LEFT_MADE \tab character \cr
   COLLEGE_CORNER_LEFT_ATTEMPT \tab character \cr
   COLLEGE_CORNER_LEFT_PCT \tab character \cr
   COLLEGE_BREAK_LEFT_MADE \tab character \cr
   COLLEGE_BREAK_LEFT_ATTEMPT \tab character \cr
   COLLEGE_BREAK_LEFT_PCT \tab character \cr
   COLLEGE_TOP_KEY_MADE \tab character \cr
   COLLEGE_TOP_KEY_ATTEMPT \tab character \cr
   COLLEGE_TOP_KEY_PCT \tab character \cr
   COLLEGE_BREAK_RIGHT_MADE \tab character \cr
   COLLEGE_BREAK_RIGHT_ATTEMPT \tab character \cr
   COLLEGE_BREAK_RIGHT_PCT \tab character \cr
   COLLEGE_CORNER_RIGHT_MADE \tab character \cr
   COLLEGE_CORNER_RIGHT_ATTEMPT \tab character \cr
   COLLEGE_CORNER_RIGHT_PCT \tab character \cr
   NBA_CORNER_LEFT_MADE \tab character \cr
   NBA_CORNER_LEFT_ATTEMPT \tab character \cr
   NBA_CORNER_LEFT_PCT \tab character \cr
   NBA_BREAK_LEFT_MADE \tab character \cr
   NBA_BREAK_LEFT_ATTEMPT \tab character \cr
   NBA_BREAK_LEFT_PCT \tab character \cr
   NBA_TOP_KEY_MADE \tab character \cr
   NBA_TOP_KEY_ATTEMPT \tab character \cr
   NBA_TOP_KEY_PCT \tab character \cr
   NBA_BREAK_RIGHT_MADE \tab character \cr
   NBA_BREAK_RIGHT_ATTEMPT \tab character \cr
   NBA_BREAK_RIGHT_PCT \tab character \cr
   NBA_CORNER_RIGHT_MADE \tab character \cr
   NBA_CORNER_RIGHT_ATTEMPT \tab character \cr
   NBA_CORNER_RIGHT_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Draft Combine - Spot Shooting}

\strong{Get NBA Stats API Draft Combine - Spot Shooting}
}
\details{
\href{https://www.nba.com/stats/draft/combine-spot-up}{Draft Combine Spot Shooting}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_draftcombinespotshooting(season_year = most_recent_nba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Draft Functions: 
\code{\link{nba_draftboard}()},
\code{\link{nba_draftcombinedrillresults}()},
\code{\link{nba_draftcombinenonstationaryshooting}()},
\code{\link{nba_draftcombineplayeranthro}()},
\code{\link{nba_draftcombinestats}()},
\code{\link{nba_drafthistory}()}
}
\author{
Saiem Gilani
}
\concept{NBA Draft Functions}
