test_that("NBA Boxscore Advanced V3", {
  skip_on_cran()
  skip_on_ci()

  x <- nba_boxscoreadvancedv3(game_id = "0022200021")

  cols_x1 <- c(
    "game_id",
    "away_team_id",
    "home_team_id",
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_slug",
    "person_id",
    "first_name",
    "family_name",
    "name_i",
    "player_slug",
    "position",
    "comment",
    "jersey_num",
    "minutes",
    "estimated_offensive_rating",
    "offensive_rating",
    "estimated_defensive_rating",
    "defensive_rating",
    "estimated_net_rating",
    "net_rating",
    "assist_percentage",
    "assist_to_turnover",
    "assist_ratio",
    "offensive_rebound_percentage",
    "defensive_rebound_percentage",
    "rebound_percentage",
    "turnover_ratio",
    "effective_field_goal_percentage",
    "true_shooting_percentage",
    "usage_percentage",
    "estimated_usage_percentage",
    "estimated_pace",
    "pace",
    "pace_per40",
    "possessions",
    "pie"
  )

  cols_x2 <- c(
    "game_id",
    "away_team_id",
    "home_team_id",
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_slug",
    "person_id",
    "first_name",
    "family_name",
    "name_i",
    "player_slug",
    "position",
    "comment",
    "jersey_num",
    "minutes",
    "estimated_offensive_rating",
    "offensive_rating",
    "estimated_defensive_rating",
    "defensive_rating",
    "estimated_net_rating",
    "net_rating",
    "assist_percentage",
    "assist_to_turnover",
    "assist_ratio",
    "offensive_rebound_percentage",
    "defensive_rebound_percentage",
    "rebound_percentage",
    "turnover_ratio",
    "effective_field_goal_percentage",
    "true_shooting_percentage",
    "usage_percentage",
    "estimated_usage_percentage",
    "estimated_pace",
    "pace",
    "pace_per40",
    "possessions",
    "pie"
  )

  cols_x3 <- c(
    "game_id",
    "away_team_id",
    "home_team_id",
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_slug",
    "minutes",
    "estimated_offensive_rating",
    "offensive_rating",
    "estimated_defensive_rating",
    "defensive_rating",
    "estimated_net_rating",
    "net_rating",
    "assist_percentage",
    "assist_to_turnover",
    "assist_ratio",
    "offensive_rebound_percentage",
    "defensive_rebound_percentage",
    "rebound_percentage",
    "estimated_team_turnover_percentage",
    "turnover_ratio",
    "effective_field_goal_percentage",
    "true_shooting_percentage",
    "usage_percentage",
    "estimated_usage_percentage",
    "estimated_pace",
    "pace",
    "pace_per40",
    "possessions",
    "pie"
  )

  cols_x4 <- c(
    "game_id",
    "away_team_id",
    "home_team_id",
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_slug",
    "minutes",
    "estimated_offensive_rating",
    "offensive_rating",
    "estimated_defensive_rating",
    "defensive_rating",
    "estimated_net_rating",
    "net_rating",
    "assist_percentage",
    "assist_to_turnover",
    "assist_ratio",
    "offensive_rebound_percentage",
    "defensive_rebound_percentage",
    "rebound_percentage",
    "estimated_team_turnover_percentage",
    "turnover_ratio",
    "effective_field_goal_percentage",
    "true_shooting_percentage",
    "usage_percentage",
    "estimated_usage_percentage",
    "estimated_pace",
    "pace",
    "pace_per40",
    "possessions",
    "pie"
  )

  expect_equal(sort(colnames(x[[1]])), sort(cols_x1))
  expect_s3_class(x[[1]], "data.frame")
  expect_equal(sort(colnames(x[[2]])), sort(cols_x2))
  expect_s3_class(x[[2]], "data.frame")
  expect_equal(sort(colnames(x[[3]])), sort(cols_x3))
  expect_s3_class(x[[3]], "data.frame")
  expect_equal(sort(colnames(x[[4]])), sort(cols_x4))
  expect_s3_class(x[[4]], "data.frame")

  Sys.sleep(3)

})
