% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClaimsByFirstReport.R
\name{claims_by_first_report}
\alias{claims_by_first_report}
\title{Claims by first report}
\usage{
claims_by_first_report(tbl_policy, frequency, payment_severity, lags)
}
\arguments{
\item{tbl_policy}{A policy data frame.}

\item{frequency}{A list of the same length as `lags` of number of claims per policy or their distributions.}

\item{payment_severity}{A list of the same length as `lags` of payment amount for each claim or their distributions.}

\item{lags}{A vector of lags as integers.}
}
\value{
A claims data frame
}
\description{
Given a data frame of policies, this will simulate the number of claims- and their initial payment-
per policy by the development lag at which they are first reported.
}
\details{
Creates a data frame with randomly generated claim values.
}
\examples{

# This will generate a claim data frame which has 1,000 records
# each of which has a severity of 100
tbl_policy <- policy_year_new(100, 2001)
tbl_claims <- claims_by_first_report(
               tbl_policy,
               frequency = 10,
               payment_severity = 100,
               lags = 1)

}
