#' Create R MR chart for statistical process control
#'
#' @description
#' Generate a moving range chart chart from a set of consecutive measurements.
#' 
#' @details
#' This type of chart is typically applied in product manufacturing to monitor
#' deviations from the target value over time. It is usually accompanied by 
#' the \code{\link{chart_IMR}}
#' 
#' @references 
#' For a complete case study application refer to \url{https://j-ramalho.github.io/industRial/}
#'
#' @param data
#' A dataset generated by the function \code{\link{process_stats}}
#'
#' @return
#' This function returns an object of class ggplot
#' @export
#' @importFrom magrittr %>%
chart_IMR <- function(data) {
  data %>%
    ggplot2::ggplot(ggplot2::aes(x = data$part_id, y = data$weight_MR)) +
    ggplot2::geom_line() +
    ggplot2::geom_point() +
    ggplot2::geom_hline(ggplot2::aes(yintercept = data$MR_max), color = "deepskyblue4", linetype = 3) +
    ggplot2::geom_hline(ggplot2::aes(yintercept = 0), color = "red", linetype = 2) +
    ggplot2::geom_point(ggplot2::aes(x = data$part_id, y = data$R_out_limits), color = "red") +
    ggplot2::theme_light() +
    ggplot2::theme(axis.text.x = ggplot2::element_text(size = 8)) +
    ggplot2::labs(
      title = "Weight SPC",
      subtitle = "MR-chart",
      x = "Part id",
      y = "Weight Moving Range [g]",
      caption = "data source: Line1"
    ) +
    industRial::theme_qcc()
}