% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wght_functions.R
\name{wght_deriv_array}
\alias{wght_deriv_array}
\title{Create an array of group weight derivatives}
\usage{
wght_deriv_array(
  parameters,
  integrand,
  allocations,
  X,
  A,
  G,
  runSilent = TRUE,
  integrate_allocation = TRUE,
  ...
)
}
\arguments{
\item{parameters}{vector of parameters passed to \code{integrand}}

\item{integrand}{function to pass to the argument 'f' of \code{\link{integrate}}.}

\item{allocations}{coverage levels in [0, 1]. Can be vector.}

\item{X}{covariate matrix}

\item{A}{vector of treatment assignments}

\item{G}{vector of group assignments}

\item{runSilent}{if FALSE, errors are printed to console. Defaults to TRUE.}

\item{integrate_allocation}{Indicator of whether the integrand function uses 
the allocation parameter. Defaults to TRUE.}

\item{...}{other arguments passed to integrand.}
}
\value{
a length(unique(group)) X length(params) X length(alphas) array of
group weight derivatives
}
\description{
Uses \code{\link{wght_deriv_calc}} to compute the weight derivatives for each
group per coverage level
}
