% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datafiles.R
\docType{data}
\name{wgain}
\alias{wgain}
\title{Weight gain data from 68 first year students during their first 12 
weeks in college}
\format{
A data frame with three columns and 68 rows:
\describe{
  \item{student}{Student number, 1 to 68.}
  \item{initial}{Initial weight in kilogram}
   \item{final}{Final weight in kilogram}
}
}
\usage{
wgain
}
\description{
Weight gain data from 68 first year students during their first 12 
weeks in college
}
\examples{
 summary(wgain)
 plot(wgain$initial, wgain$final)
 abline(0, 1, col="red")
 plot(wgain$initial, wgain$final, xlab="Wt in Week 1", 
 ylab="Wt in Week 12", pch="*", las=1)
 abline(0, 1, col="red")
 title("A scatter plot of the weights in Week 12 against 
 the  weights in Week 1")
 # 95\% Confidence interval for mean weight gain 
 x <- wgain$final - wgain$initial
 mean(x) + c(-1, 1) * qt(0.975, df=67) * sqrt(var(x)/68)
 # t-test to test the mean difference equals 0
 t.test(x)
}
\keyword{datasets}
