% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_to_transmittance.R
\name{ir_to_transmittance}
\alias{ir_to_transmittance}
\alias{ir_to_absorbance}
\title{Converts absorbance spectra to transmittance spectra or vice versa}
\source{
\insertCite{Stuart.2004}{ir}.
}
\usage{
ir_to_transmittance(x)

ir_to_absorbance(x)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}
}
\value{
\code{x} with y values fore each spectrum as transmittance values
(in case of \code{ir_to_transmittance}) or absorbance values (in case of
\code{ir_to_absorbance}).
}
\description{
\code{ir_to_transmittance} converts absorbance spectra to transmittance
spectra. \code{ir_to_absorbance} converts transmittance spectra to absorbance
spectra. Note that neither function checks whether the input spectra are
absorbance or transmittance spectra.
}
\examples{
# convert from absorbance to transmittance
x1 <-
    ir_sample_data |>
    ir_to_transmittance()

# convert from transmittance to absorbance
x2 <-
    x1 |>
    ir::ir_to_absorbance()

vapply(
  seq_along(x2$spectra),
  FUN = function(i) all.equal(x2$spectra[[i]], ir::ir_sample_data$spectra[[i]]),
  FUN.VALUE = logical(1L)
) |>
  all()

}
\references{
\insertAllCited{}
}
