% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters_tree.R
\name{parameters_tree}
\alias{parameters_tree}
\title{Print parameter dependencies as a tree}
\usage{
parameters_tree(parameters)
}
\arguments{
\item{parameters}{(\code{list()}) Parameter space in irace format. See the function \code{\link[irace:readParameters]{irace::readParameters()}}.}
}
\description{
Print parameter dependencies as a tree
}
\examples{
# Read the parameters directly from text.
parameters_tab <- '
a "" i (2, 10)
b "" c (yes, no) | a < 5
c "" o (low, medium, high) | (a == 2) | (b == "yes")
d "" r (a, 50)
'
parameters <- irace::readParameters(text=parameters_tab)
parameters_tree(parameters)

}
\author{
Manuel López-Ibáñez
}
