% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_istatdata.R
\name{search_istatdata}
\alias{search_istatdata}
\title{Search data sets by keywords (source: IstatData).}
\usage{
search_istatdata(keywords,
                 lang = "ita")
}
\arguments{
\item{keywords}{keyword(s) to search data sets}

\item{lang}{language parameter for labels ("ita" for Italian, "eng" for English)}
}
\value{
It returns a list of data sets containing the keyword(s) with their ids and names.
}
\description{
Search IstatData data sets by keywords. To download data sets use "get_istatdata" function and insert data set ids.
}
\note{
Searching may take some time. Future versions will speed up the process.
}
\examples{
\donttest{search_istatdata(c( "incidenti", "stradali"))}
\donttest{search_istatdata("population", lang="eng")}
}
