% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.test.asymptotic.R
\name{jaccard.test.asymptotic}
\alias{jaccard.test.asymptotic}
\title{Compute p-value using an asymptotic approximation}
\usage{
jaccard.test.asymptotic(x, y, px = NULL, py = NULL, verbose = TRUE)
}
\arguments{
\item{x}{a binary vector (e.g., fingerprint)}

\item{y}{a binary vector (e.g., fingerprint)}

\item{px}{probability of successes in \code{x} (optional)}

\item{py}{probability of successes in \code{y} (optional)}

\item{verbose}{whether to print progress messages}
}
\value{
\code{jaccard.test.asymptotic} returns a list consisting of
\item{statistics}{centered Jaccard/Tanimoto similarity coefficient}
\item{pvalue}{p-value}
\item{expectation}{expectation}
}
\description{
Compute statistical significance of Jaccard/Tanimoto similarity coefficients.
}
\examples{
set.seed(1234)
x = rbinom(100,1,.5)
y = rbinom(100,1,.5)
jaccard.test.asymptotic(x,y)
}
