% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adorn_pct_formatting.R
\name{adorn_pct_formatting}
\alias{adorn_pct_formatting}
\title{Format a data.frame of decimals as percentages.}
\usage{
adorn_pct_formatting(
  dat,
  digits = 1,
  rounding = "half to even",
  affix_sign = TRUE,
  ...
)
}
\arguments{
\item{dat}{a data.frame with decimal values, typically the result of a call to \code{adorn_percentages} on a \code{tabyl}.  If given a list of data.frames, this function will apply itself to each data.frame in the list (designed for 3-way \code{tabyl} lists).}

\item{digits}{how many digits should be displayed after the decimal point?}

\item{rounding}{method to use for rounding - either "half to even", the base R default method, or "half up", where 14.5 rounds up to 15.}

\item{affix_sign}{should the \% sign be affixed to the end?}

\item{...}{columns to adorn.  This takes a tidyselect specification.  By default, all numeric columns (besides the initial column, if numeric) are adorned, but this allows you to manually specify which columns should be adorned, for use on a data.frame that does not result from a call to \code{tabyl}.}
}
\value{
a data.frame with formatted percentages
}
\description{
Numeric columns get multiplied by 100 and formatted as percentages according to user specifications.  This function defaults to excluding the first column of the input data.frame, assuming that it contains a descriptive variable, but this can be overridden by specifying the columns to adorn in the \code{...} argument.  Non-numeric columns are always excluded.

The decimal separator character is the result of \code{getOption("OutDec")}, which is based on the user's locale.  If the default behavior is undesirable,
change this value ahead of calling the function, either by changing locale or with \code{options(OutDec = ",")}.  This aligns the decimal separator character with that used in \code{base::print()}.
}
\examples{

mtcars \%>\%
  tabyl(am, cyl) \%>\%
  adorn_percentages("col") \%>\%
  adorn_pct_formatting()
  
# Control the columns to be adorned with the ... variable selection argument
# If using only the ... argument, you can use empty commas as shorthand 
# to supply the default values to the preceding arguments:

cases <- data.frame(
  region = c("East", "West"),
  year = 2015,
  recovered = c(125, 87),
  died = c(13, 12)
)

cases \%>\%
 adorn_percentages("col",,recovered:died) \%>\%
 adorn_pct_formatting(,,,recovered:died)

}
