% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{count_in}
\alias{count_in}
\title{Count in}
\usage{
count_in(x, y, na.rm = TRUE, ignore.case = FALSE)
}
\arguments{
\item{x}{A vector to check.}

\item{y}{A vector to compare against.}

\item{na.rm}{logical; Should \code{NA} be ignored?}

\item{ignore.case}{logical; if \code{FALSE}, the pattern matching is case
sensitive and if \code{TRUE}, case is ignored during matching.}
}
\value{
The sum of \code{x} present in \code{y}.
}
\description{
Count the total values of \code{x} that are \code{\%in\%} the vector \code{y}.
}
\details{
\code{sum(x \%out\% y)}
}
\examples{
count_in(c("VT", "NH", "ZZ", "ME"), state.abb)
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_na}()},
\code{\link{count_out}()},
\code{\link{na_in}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_distinct}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{prop_out}()},
\code{\link{what_in}()},
\code{\link{what_out}()}
}
\concept{counting wrappers}
