% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa_inference.R
\name{kappa_test}
\alias{kappa_test}
\title{Significance test for homogeneity of kappa coefficients in independent groups}
\usage{
kappa_test(kappas, val = "value0", se = "se0", conf.level = 0.95)
}
\arguments{
\item{kappas}{list of kappas from different groups. It uses the kappa
estimate and its standard error.}

\item{val}{character. Name of field to extract kappa coefficient estimate.}

\item{se}{character. Name of field to extract standard error of kappa.}

\item{conf.level}{numeric. confidence level of confidence interval for
overall kappa}
}
\value{
list containing the test results, including the entries \code{statistic}
and \code{p.value} (class \code{htest})
}
\description{
The null hypothesis states that the kappas for all involved groups are the
same ("homogeneous"). A prerequisite is that the groups are independent of
each other, this means the groups are comprised of different subjects and
each group has different raters. Each rater employs a nominal scale. The test
requires estimates of kappa and its standard error per group.
}
\details{
A common overall kappa coefficient across groups is estimated. The test
statistic assesses the weighted squared deviance of the individual kappas
from the overall kappa estimate. The weights depend on the provided standard
errors. Under H0, the test statistics is chi-square distributed.
}
\examples{
# three independent agreement studies (different raters, different subjects)
# each study involves two raters that employ a binary rating scale
k2_studies <- lapply(agreem_binary, kappa2)

# combined estimate and test for homogeneity of kappa
kappa_test(kappas = k2_studies, val = "value", se = "se")


}
\references{
Joseph L. Fleiss, Statistical Methods for Rates and Proportions,
3rd ed., 2003, section 18.1
}
