% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{predict.kdecopula}
\alias{predict.kdecopula}
\title{Prediction method for \code{kdecop()} fits}
\usage{
\method{predict}{kdecopula}(object, newdata, what = "pdf", stable = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{kdecopula}.}

\item{newdata}{evaluation point(s), a length two vector or a matrix with
two columns.}

\item{what}{what to predict, one of \code{c("pdf", "cdf", "hfunc1", "hfunc2", "hinv1", "hinv2")}.}

\item{stable}{only used for \code{what = "pdf"}, see \code{dkdecop()}.}

\item{...}{unused.}
}
\value{
A numeric vector of predictions.
}
\description{
Predicts the pdf, cdf, or (inverse) h-functions by calling \code{dkdecop()},
\code{pkdecop()}, or \code{hkdecop()}.
}
\examples{
data(wdbc)
udat <- apply(wdbc[, -1], 2, function(x) rank(x) / (length(x) + 1))
fit <- kdecop(udat[, 5:6])

all.equal(predict(fit, c(0.1, 0.2)), dkdecop(c(0.1, 0.2), fit))
all.equal(predict(fit, udat, "hfunc1"), hkdecop(udat, fit, cond.var = 1))
}
