% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{Spe}
\alias{Spe}
\title{Specificity or TNR}
\usage{
Spe(ct, multi.class = "macro")
}
\arguments{
\item{ct}{Confusion Matrix.}

\item{multi.class}{Should the results of each class be aggregated, and how?
Options: "none", "macro", "micro". (Defaults: "macro").}
}
\value{
TNR (a single value).
}
\description{
`Spe()` computes the Specificity or TNR (True Negative Rate) between the output
of a classification prediction model and the actual values of the target.
}
\examples{
y <- c(rep("a",3),rep("b",2))
y_pred <- c(rep("a",2),rep("b",3))
ct <- table(y,y_pred)
Spe(ct)
}
