% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knnmi.R
\name{mutual_inf_cd}
\alias{mutual_inf_cd}
\title{Mutual information estimation}
\usage{
mutual_inf_cd(target, features, k = 3L)
}
\arguments{
\item{target}{input vector.}

\item{features}{input vector or matrix.}

\item{k}{Integer number of nearest neighbors. The default value is 3.}
}
\value{
Returns the estimated mutual information. The return value is a vector of size 1 if the features argument is
a vector. If the features argument is a matrix then the return value is a vector whose size matches the
number of rows in the matrix.
}
\description{
Estimate the mutual information MI(X;Y) of the target \code{X} and features \code{Y}
where \code{X} is continuous or discrete and \code{Y} is discrete using k-nearest neighbor distances.
}
\details{
The features argument is a vector of the same size as the target vector, or a matrix whose column dimension matches
the size of the target vector. Discrete values for the features or targets must be numeric or integer types.
}
\examples{

data(mutual_info_df)
set.seed(654321)
mutual_inf_cd(mutual_info_df$Zc_XdYd, t(mutual_info_df$Xd))

M <- cbind(mutual_info_df$Xd, mutual_info_df$Yd)
mutual_inf_cd(mutual_info_df$Zc_XdYdWd, t(M))


}
\references{
Ross BC (2014) Mutual Information between Discrete and Continuous Data Sets. PLoS ONE 9(2): e87357.
\doi{10.1371/journal.pone.0087357}
}
