% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreprocessingFunctions.R
\name{calculate_rms}
\alias{calculate_rms}
\title{Calculate sample-to-sample root mean square distance (RMS) of a data segment}
\usage{
calculate_rms(gaze_in, xcol = "x.raw", ycol = "y.raw", one_degree = 40)
}
\arguments{
\item{gaze_in}{data frame with gaze to process. Must contain the variables specified in the parameters 'xcol' and 'ycol'}

\item{xcol}{Name of column containing x coordinates}

\item{ycol}{Name of column containing y coordinates}

\item{one_degree}{One degree of the visual field in the units of the X and Y coordinates as specified in 'xcol' and 'ycol'}
}
\value{
sample-to-sample RMS
}
\description{
Calculate the RMS of a gaze segment with X and Y coordinates.
RMS is inversely related to precision, so that lower RMS indicates higher precision
calculate_rms calculates the root mean square of the Euclidean distance between subsequent samples
Adjust the parameters 'xcol' and 'ycol' to specify the data you want to work with. For example, it is possible to calculate
the RMS of the left and right eye separately by specifying appropriate columns.
}
\examples{
rms <- calculate_rms(sample.data.unprocessed)
}
