% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.samples.R
\name{mcmc.samples}
\alias{mcmc.samples}
\alias{mcmc.samples.krige}
\alias{mcmc.samples.summary.krige}
\alias{as.matrix.krige}
\alias{as.matrix.summary.krige}
\alias{as.data.frame.krige}
\alias{as.data.frame.summary.krige}
\title{Extract MCMC Samples}
\usage{
mcmc.samples(object, as.matrix, as.data.frame, ...)

\method{mcmc.samples}{krige}(object, as.matrix = !as.data.frame, as.data.frame = FALSE, ...)

\method{mcmc.samples}{summary.krige}(object, as.matrix = !as.data.frame, as.data.frame = FALSE, ...)

\method{as.matrix}{krige}(x, ...)

\method{as.matrix}{summary.krige}(x, ...)

\method{as.data.frame}{krige}(x, ...)

\method{as.data.frame}{summary.krige}(x, ...)
}
\arguments{
\item{object}{A \code{krige}or \code{summary.krige} object from the \code{metropolis.krige} function.}

\item{as.matrix}{Logical values indicating if the output format should be a matrix. Defaults to \code{TRUE}.}

\item{as.data.frame}{Logical values indicating if the output format should be a 
data.frame. Defaults to \code{FALSE}.}

\item{\dots}{Additional arguments passed to \code{as.matrix} or \code{as.data.frame} methods.}

\item{x}{A \code{krige} or \code{summary.krige} object for \code{as.matrix} and \code{as.data.frame} methods.}
}
\value{
A \code{summary.krige} list object.
}
\description{
Extract MCMC samples estimated by \code{metropolis.krige()}
}
\details{
The function extracts the MCMC samples from the a \code{krige}or \code{summary.krige} 
  object from the \code{metropolis.krige} function. Users can define the output by using \code{as.matrix}
  or \code{as.data.frame}.
}
\examples{
\dontrun{
# Summarize Data
summary(ContrivedData)

# Initial OLS model
contrived.ols<-lm(y~x.1+x.2,data=ContrivedData)
# summary(contrived.ols)

# Set seed
set.seed(1241060320)

M <- 100
#M<-10000

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
   data = ContrivedData, n.iter = M, n.burnin = 20, range.tol = 0.05)
   
contrived.run.mat <- mcmc.samples(contrived.run)

### Alternatively, use generic methods
contrived.run.mat <- as.matrix(contrived.run)
contrived.run.df <- as.data.frame(contrived.run)
}

}
\seealso{
\code{\link{as.mcmc.krige}}
}
