% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-usage-tracking.R
\name{kvk_reset_usage}
\alias{kvk_reset_usage}
\title{Reset session usage tracking data}
\usage{
kvk_reset_usage()
}
\value{
Invisibly returns NULL. The function is called for its side effect
of clearing session usage data.
}
\description{
Clear all API usage data from the current R session. This action cannot be undone
and will reset your session usage history including call counts, timestamps,
and cost calculations.
}
\details{
This function clears the session-based usage tracking data stored in memory.
After reset:
\itemize{
\item All session usage history is cleared
\item \code{\link{kvk_usage_report}} will show no data
\item Session cost calculations restart from zero
\item Usage alerts continue with the new baseline
}

The function only affects session usage data. It does not change:
\itemize{
\item Usage alert settings (these are stored in R options)
\item API key configuration
\item Package preferences
}

This can be useful for:
\itemize{
\item Starting fresh tracking within a long R session
\item Clearing test data before production use
\item Resetting session counters for specific analyses
\item Troubleshooting usage tracking issues
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Clear session usage history
kvk_reset_usage()

# Verify reset worked
kvk_usage_report()  # Should show "No usage data found"

# Usage tracking will restart with new API calls
results <- kvk_search(plaats = "Amsterdam")
kvk_usage_report()  # Will show the new call
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{kvk_usage_report}} for viewing current usage,
\code{\link{kvk_export_usage}} for exporting session data,
\code{\link{kvk_usage_alert}} for setting usage limits
}
