% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strand.R
\name{strand.suppress}
\alias{strand.suppress}
\title{Suppress Element from Strands}
\usage{
strand.suppress(strands, obj, elements)
}
\arguments{
\item{strands}{A list of strands, which are data frames returned by \code{\link[lakhesis]{ca.procrustes.curve}}.}

\item{obj}{The intial incidence matrix.}

\item{elements}{A vector of one or more row or column ids to suppress.}
}
\value{
A list of the strands.
}
\description{
Given a list of strands, remove a row or column element and re-run seriation by correspondence analysis with Procrustes fitting (\code{\link[lakhesis]{ca.procrustes.curve}}) to generate a new list of strands that exclude the specified elements. If the resulting strand lacks sufficient points to perform correspondence analysis, that strand is deleted in the output.
}
\examples{
data("quattrofontanili")
data("qfStrands")
strand.suppress(qfStrands, quattrofontanili, "QF II 15-16")

strand.suppress(qfStrands, quattrofontanili, c("QF II 15-16", "I", "XIV"))

}
