% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_wording_effects.R
\name{add_wording_effects}
\alias{add_wording_effects}
\title{Adds Wording Effects to \code{\link[latentFactoR]{simulate_factors}} Data}
\usage{
add_wording_effects(
  lf_object,
  method = c("acquiescence", "difficulty", "random_careless", "straight_line", "mixed"),
  proportion_negative = 0.5,
  proportion_negative_range = NULL,
  proportion_biased_cases = 0.1,
  proportion_biased_variables = 1,
  proportion_biased_variables_range = NULL,
  proportion_biased_person = 1,
  proportion_biased_person_range = NULL
)
}
\arguments{
\item{lf_object}{Data object from \code{\link[latentFactoR]{simulate_factors}}.
Data \strong{must} be categorical. If data are not categorical, then
there function with throw an error}

\item{method}{Character (length = 1).
Method to generate wording effect to add to the data.
Description of methods:

\itemize{

\item \code{"acquiescence"} ---Generates new data with flipped dominant loadings
(based on \code{proportion_negative}) and ensures a bias
such that variables have a restricted range of responding
(e.g., only 4s and 5s on a 5-point Likert scale)

\item \code{"difficulty"} --- Generates new data with flipped dominant loadings
(based on \code{proportion_negative}) and uses this data
as the data without wording effects. Then, the signs of the
dominant loadings are obtained and the dominant loadings are
made to be absolute. Finally, the skews are multiplied by
the signs of the original dominant loadings when generating
the data with the wording effects

\item \code{"random_careless"} --- Number of cases up to \code{proportion_biased_cases}
are sampled and replaced by values from a random uniform distribution ranging
between the lowest and highest response category for each variable.
These values then replace the values in the original data

\item \code{"straight_line"} --- Coming soon...

}}

\item{proportion_negative}{Numeric (length = 1 or \code{factors}).
Proportion of variables that should have negative (or flipped) dominant loadings across all
or each factor. Accepts number of variables as well.
The first variables on each factor, up to the corresponding proportion, will be
flipped. Set to \code{0} to not have any loadings flipped.
Defaults to \code{0.50}}

\item{proportion_negative_range}{Numeric (length = 2).
Range of proportion of variables that are randomly selected from
a uniform distribution. Accepts number of number of variables as well.
Defaults to \code{NULL}}

\item{proportion_biased_cases}{Numeric (length = 1).
Proportion of cases that should be biased with wording effects.
Also accepts number of cases to be biased. The first \emph{n} number of cases,
up to the corresponding proportion, will be biased.
Defaults to \code{0.10} or 10 percent of cases.}

\item{proportion_biased_variables}{Numeric (length = 1 or \code{factors}).
Proportion of variables that should be biased with wording effects.
For \code{method = "difficulty"}, proportion of biased variables will only
count for the negative variables.
For \code{method = "acquiescence"}, proportion of biased variables will only
count for variables below the mid-point of the \code{variable_categories}.
Defaults to \code{1} or all possible variables}

\item{proportion_biased_variables_range}{Numeric (length = 2).
Range of proportion of variables that should be biased with wording effects.
Values are drawn randomly from a uniform distribution.
Defaults to \code{NULL}}

\item{proportion_biased_person}{Numeric (length = 1 or \code{proportion_biased_cases} x \code{sample_size}).
Person-specific parameter of how many much bias the \code{proportion_biased_cases} will
have over the possible biased variables. This parameter interacts with
\code{proportion_biased_variables}. Parameter specifies the proportion of variables
that should have bias per person.
If one value is provided, then all biased cases will have the same proportion of variables biased.
Individual values are possible by providing values for each biased case
(\code{round(nrow(lf_object$data) * proportion_biased_cases)}). Setting individual
values for each biased case is not recommended
(use \code{proportion_biased_person_range} instead).
Defaults to \code{1} or all possible biased variables for all biased cases}

\item{proportion_biased_person_range}{Numeric (length = 2).
Range to randomly draw bias from a uniform distribution. Allows for random
person-specific bias to be obtained.
Defaults to \code{NULL}}
}
\value{
Returns a list containing:

\item{data}{Biased data simulated data from the specified factor model}

\item{unbiased_data}{The corresponding unbiased data prior to replacing values
to generate the (biased) \code{data}}

\item{biased_sample_size}{The number of cases that have biased data}

\item{adjusted_results}{Bias-adjusted \code{lf_object} input into function}

\item{original_results}{Original \code{lf_object} input into function}
}
\description{
Adds wording effects to simulated data from \code{\link[latentFactoR]{simulate_factors}}.
See examples to get started
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000, # number of cases = 1000
  variable_categories = 5 # 5-point Likert scale
)

# Add wording effects using acquiescence method
two_factor_acquiescence <- add_wording_effects(
  lf_object = two_factor,
  proportion_negative = 0.50,
  proportion_biased_cases = 0.10,
  method = "acquiescence"
)

# Add wording effects using difficulty method
two_factor_difficulty <- add_wording_effects(
  lf_object = two_factor,
  proportion_negative = 0.50,
  proportion_biased_cases = 0.10,
  method = "difficulty"
)

# Add wording effects using random careless method
two_factor_random_careless <- add_wording_effects(
  lf_object = two_factor,
  proportion_negative = 0.50,
  proportion_biased_cases = 0.10,
  method = "random_careless"
)

# Add wording effects using straight line method
two_factor_random_careless <- add_wording_effects(
  lf_object = two_factor,
  proportion_negative = 0.50,
  proportion_biased_cases = 0.10,
  method = "straight_line"
)

# Add wording effects using mixed method
two_factor_mixed <- add_wording_effects(
  lf_object = two_factor,
  proportion_negative = 0.50,
  proportion_biased_cases = 0.10,
  method = "mixed"
)

# Add wording effects using acquiescence and straight line method
two_factor_multiple <- add_wording_effects(
  lf_object = two_factor,
  proportion_negative = 0.50,
  proportion_biased_cases = 0.10,
  method = c("acquiescence", "straight_line")
)

}
\references{
Garcia-Pardina, A., Abad, F. J., Christensen, A. P., Golino, H., & Garrido, L. E. (2022).
Dimensionality assessment in the presence of wording effects: A network psychometric and factorial approach.
\emph{PsyArXiv}.

Garrido, L. E., Golino, H., Christensen, A. P., Martinez-Molina, A., Arias, V. B., Guerra-Pena, K., ... & Abad, F. J. (2022).
A systematic evaluation of wording effects modeling under the exploratory structural equation modeling framework.
\emph{PsyArXiv}.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
