% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{residuals.lcModel}
\alias{residuals.lcModel}
\title{Extract lcModel residuals}
\usage{
\method{residuals}{lcModel}(object, ..., clusters = trajectoryAssignments(object))
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{Additional arguments.}

\item{clusters}{Optional cluster assignments per id. If unspecified, a \code{matrix} is returned containing the cluster-specific predictions per column.}
}
\value{
A \verb{numeric vector} of residuals for the cluster assignments specified by clusters.
If the \code{clusters} argument is unspecified, a \code{matrix} of cluster-specific residuals per observations is returned.
}
\description{
Extract the residuals for a fitted \code{lcModel} object.
By default, residuals are computed under the most likely cluster assignment for each trajectory.
}
\seealso{
\link{fitted.lcModel} \link{trajectories}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
