% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-fred_data.R
\name{ldhmm.fred_data}
\alias{ldhmm.fred_data}
\title{Utility to download time series from FRED}
\usage{
ldhmm.fred_data(symbol, col_out = "Close", do.logr = TRUE)
}
\arguments{
\item{symbol}{character, the name of the time series}

\item{col_out}{character, the name of the output closing price column. Default: "Close"}

\item{do.logr}{logical, if \code{TRUE} (default), produce xts object of logr; otherwise, just the \code{col_out} column.
Be aware that, because logr uses diff, the first day close will be deleted.}
}
\value{
The xts object for the time series
}
\description{
This utility downloads time series from FRED. It serves as a data source for daily data,
e.g. SP500 for S&P 500, and VIXCLS for CBOE VIX index. This can be concatenated to the 
static data to provide daily updates.
}
\examples{
\dontrun{
ldhmm.fred_data("VIXCLS")
}
}
\keyword{data}
