% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-plot_spx_vix_obs.R
\name{ldhmm.plot_spx_vix_obs}
\alias{ldhmm.plot_spx_vix_obs}
\title{Plotting HMM expected volatility for SPX overlaid with adjusted VIX}
\usage{
ldhmm.plot_spx_vix_obs(
  object,
  days.pa = 252,
  start.date = NULL,
  end.date = NULL,
  px.origin = NULL,
  px.scale = NULL,
  vix.adj.ratio = NULL,
  insert.plot = TRUE,
  insert.viewport = NULL
)
}
\arguments{
\item{object}{an ldhmm object with a stationary solution. If this is set to \code{NULL},
an internal 10-state HMM object will be used.}

\item{days.pa}{a positive integer specifying trading days per year, default is 252.}

\item{start.date}{Date or character of ISO format (YYYY-MM-DD), 
specifying the start date of the plot, default is \code{NULL}, which is converted to 1.5 years ago.}

\item{end.date}{Date or character of ISO format (YYYY-MM-DD), 
specifying the end date of the plot, default is \code{NULL}, which means the latest date.}

\item{px.origin}{numeric, specifying the starting value of the index price line,
the default is \code{NULL}, which will start the index price line from the middle of y-axis.}

\item{px.scale}{numeric, specifying the scaling factor when plotting price trend, default is 15.
The closing price is converted to cumulative return by the price of the first date.
Then plot from the mid-point of volatility axis with this scale.}

\item{vix.adj.ratio}{numeric, if specified, VIX index is adjusted and plotted, default is \code{NULL}.
Default is to use the long-term ratio between VIX and 10-state HMM, which is about 0.79.}

\item{insert.plot}{logical, if true, also plot the volatility-return as insert in upper-right corner, default is \code{TRUE}.}

\item{insert.viewport}{optional viewport for the insert, default is \code{NULL}, 
which is internally set to \code{grid::viewport(.8, .75, .3, .3)}.}
}
\description{
This utility plots the HMM expected volatility of SPX overlaid with the VIX index adjusted by a ratio.
The expected volatility is shown to have a long-term ratio of 0.79 relative to the VIX index. This plot will
show how HMM deviates from VIX in a shorter time window.
Optionally the insert shows the relation between the return and volatility indicated by each state. 
This plot is also called "volatility yield curve".
}
\examples{
\dontrun{
    ldhmm.plot_spx_vix_obs(h)
}
}
\author{
Stephen H. Lihn
}
\keyword{VIX}
