% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_resX.R
\name{gg_resX}
\alias{gg_resX}
\title{Generate residual plot of residuals against predictors}
\usage{
gg_resX(
  fitted.lm,
  plot.all = TRUE,
  scale.factor = 0.5,
  max.per.page = NA,
  ncol = NA
)
}
\arguments{
\item{fitted.lm}{a fitted linear model (i.e. lm, glm) that contains fitted regression}

\item{plot.all}{boolean value to determine whether plot will be return as
a plot arranged using `grid.arrange()`. When set to false, the function
would return a list of residual plots. Parameter defaults to TRUE.}

\item{scale.factor}{numeric; scales the point size and linewidth to allow customized viewing. Defaults to 0.5.}

\item{max.per.page}{numeric; maximum number of plots allowed in one page. Parameter defaults to fit all plots on one page.}

\item{ncol}{specify number of columns in resulting plot per page. Default to make a square matrix of the output.}
}
\value{
An arranged grid of residuals against predictor values plots in ggplot.
If plotall is set to FALSE,  a list of ggplot objects will be returned instead.
Name of the plots are set to respective variable names.
}
\description{
Generate residual plot of residuals against predictors
}
\examples{
library(MASS)
data(Cars93)
# a regression with categorical variable
cars_lm <- lm(Price ~ Passengers + Length + RPM + Origin, data = Cars93)
gg_resX(cars_lm)
# customize which diagnostic plot is included by have gg_resX to return a list of plots
plots <- gg_resX(cars_lm, plot.all = FALSE)
names(plots)     # get name of the plots
exclude_plots <- plots[-1 ]    #exclude certain residual plots
include_plots <- plots[1]      # include certain residual plots
plot_all(exclude_plots)       # make use of plot_all() in lindia
plot_all(include_plots)
}
