% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{generate_default_cost_matrix}
\alias{generate_default_cost_matrix}
\title{Generate a default cost matrix}
\usage{
generate_default_cost_matrix(data, delim = "")
}
\arguments{
\item{data}{DataFrame to be computed.}

\item{delim}{The delimiter separating atomic symbols.}
}
\value{
Cost matrix contains all possible characters in the raw data with all diagonal values set to 0 and others set to 1.
}
\description{
generate a default cost matrix contains all possible characters in the raw data with all diagonal values set to 0 and others set to 1. This avoids you constructing the matrix from scratch.
}
\examples{
df <- as.data.frame(rbind(a=c("a_bc_d","d_bc_a"),b=c("b_bc_d","d_bc_a")))
default.cost <- generate_default_cost_matrix(df, "_")
}
