% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_meta.R
\name{dictionary_meta}
\alias{dictionary_meta}
\title{Assess Dictionary Categories Within a Latent Semantic Space}
\usage{
dictionary_meta(dict, space = "auto", n_spaces = 5, suggest = FALSE,
  suggestion_terms = 10, suggest_stopwords = FALSE,
  suggest_discriminate = TRUE, expand_cutoff_freq = 0.98,
  expand_cutoff_spaces = 10, dimension_prop = 1, pairwise = TRUE,
  glob = TRUE, space_dir = getOption("lingmatch.lspace.dir"),
  verbose = TRUE)
}
\arguments{
\item{dict}{A vector of terms, list of such vectors, or a matrix-like object to be
categorized by \code{\link{read.dic}}.}

\item{space}{A vector space used to calculate similarities between terms.
Names of spaces (see \code{\link{select.lspace}}), a matrix with terms as row names, or
\code{"auto"} to auto-select a space based on matched terms. This can also be \code{multi}
to use multiple spaces, which are combined after similarities are calculated.}

\item{n_spaces}{Number of spaces to draw from if \code{space} is \code{multi}.}

\item{suggest}{Logical; if \code{TRUE}, will search for other terms for possible inclusion
in \code{space}.}

\item{suggestion_terms}{Number of terms to use when selecting suggested additions.}

\item{suggest_stopwords}{Logical; if \code{TRUE}, will suggest function words.}

\item{suggest_discriminate}{Logical; if \code{TRUE}, will adjust for similarity to other
categories when finding suggestions.}

\item{expand_cutoff_freq}{Proportion of mapped terms to include when expanding dictionary terms.
Applies when \code{space} is a character (referring to a space to be loaded).}

\item{expand_cutoff_spaces}{Number of spaces in which a term has to appear to be considered
for expansion. Applies when \code{space} is a character (referring to a space to be loaded).}

\item{dimension_prop}{Proportion of dimensions to use when searching for suggested additions,
where less than 1 will calculate similarities to the category core using fewer dimensions
of the space.}

\item{pairwise}{Logical; if \code{FALSE}, will compare candidate suggestion terms with a single,
averaged category vector rather than all category terms separately.}

\item{glob}{Logical; if \code{TRUE}, converts globs (asterisk wildcards) to regular expressions.}

\item{space_dir}{Directory from which \code{space} should be loaded.}

\item{verbose}{Logical; if \code{FALSE}, will not show status messages.}
}
\value{
A list:
\itemize{
  \item \strong{\code{expanded}}: A version of \code{dict} with fuzzy terms expanded.
  \item \strong{\code{summary}}: A summary of each dictionary category.
  \item \strong{\code{terms}}: Match (expanded term) similarities within terms and categories.
  \item \strong{\code{suggested}}: If \code{suggest} is \code{TRUE}, a list with suggested
  additions for each dictionary category. Each entry is a named numeric vector with
  similarities for each suggested term.
}
}
\description{
Assess Dictionary Categories Within a Latent Semantic Space
}
\examples{
if (dir.exists("~/Latent Semantic Spaces")) {
  dict <- list(
    furniture = c("table", "chair", "desk*", "couch*", "sofa*"),
    well_adjusted = c("happy", "bright*", "friend*", "she", "he", "they")
  )
  dictionary_meta(dict, space_dir = "~/Latent Semantic Spaces")
}
}
\seealso{
To just expand fuzzy terms, see \code{\link{report_term_matches}()}.

Similar information is provided in the \href{https://miserman.github.io/dictionary_builder/}{dictionary builder} web tool.

Other Dictionary functions: 
\code{\link{download.dict}()},
\code{\link{lma_patcat}()},
\code{\link{lma_termcat}()},
\code{\link{read.dic}()},
\code{\link{report_term_matches}()},
\code{\link{select.dict}()}
}
\concept{Dictionary functions}
