% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectors.R
\name{selectors}
\alias{selectors}
\alias{sel_id}
\alias{sel_input}
\alias{sel_all}
\alias{sel_class}
\alias{sel_tag}
\alias{sel_attr}
\title{Selectors}
\usage{
sel_id(value)

sel_input(value)

sel_all()

sel_class(value)

sel_tag(value)

sel_attr(attribute, value = NULL, tag = NULL)
}
\arguments{
\item{value}{Value of selector.}

\item{attribute}{Name of attribute.}

\item{tag}{Name of tag.}
}
\description{
Create selectors to select particular elements.
}
\details{
The functions will print in the console the CSS selector they compose.
}
\section{Functions}{

\itemize{
\item \code{\link[=sel_id]{sel_id()}} - Select an object by its id, e.g.: \code{sel_id('btn')} selects \code{shiny::actionButton('btn', 'Button')}.
\item \code{\link[=sel_all]{sel_all()}} - Selects everything.
\item \code{\link[=sel_input]{sel_input()}} - Selects an input by its id, e.g.: \code{sel_id('txt')} selects \code{shiny::textInput('txt', 'Text')}.
\item \code{\link[=sel_class]{sel_class()}} - Select all elements bearing a specific class, e.g.: \code{sel_class('cls')}, selects \code{shiny::h1('hello', class = 'cls')}.
\item \code{\link[=sel_tag]{sel_tag()}} - Select all tags, e.g.: \code{sel_tag('p')} selects \code{p('hello')}.
\item \code{\link[=sel_attr]{sel_attr()}} - Select all tags with a specific attribute.
}
}

\examples{
# select element where id = x
sel_id("x")

# select all elements with class = "container"
sel_class("container")

}
\seealso{
\code{\link{\%with\%}}, \code{\link{\%or\%}}, and \code{\link{\%child\%}} as well as
\code{\link[=when_active]{when_active()}}, \code{\link[=when_hover]{when_hover()}}, and \code{\link[=when_focus]{when_focus()}}
for more sophisticated element selection.
}
